﻿IF  EXISTS (SELECT * FROM sys.objects 
            WHERE object_id = OBJECT_ID(N'[dbo].[UFD_BUSCA_QT_SOL_PED_CP]') 
            AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))

DROP FUNCTION [dbo].[UFD_BUSCA_QT_SOL_PED_CP]
GO
/*
	FUNCTION BUSCA A QUANTIDADE GERADA NO PEDIDO APARTIR DO PEDIDO DE SOLICITACAO

	EMPRESA: CORPORATE BUSINES
	DATA INICIO:  23/10/2003
	DATA TERMINO: 23/10/2003 
	PROFISSIONAL: Flavio Araujo
*/
--Select DISTINCT  CD_EMP, CD_FILIAL, CD_PED_SOL, CD_PROD, DS_PROD, DS_UN, QT_IT_SOL, QT_IT_AT , VLR_TOT_PROD, QT_SLD, CD_PROD_FORN,UFD.PERC_DESC From UFD_BUSCA_QT_SOL_PED_CP(1,'16','22919','0,1,2',12030,0,0,0) UFD Where   QT_SLD > 0 Order By CD_FILIAL, CD_PED_SOL,DS_PROD
CREATE FUNCTION [dbo].[UFD_BUSCA_QT_SOL_PED_CP]
--DROP FUNCTION UFD_BUSCA_QT_SOL_PED_CP
--CREATE FUNCTION UFD_BUSCA_QT_SOL_PED_CP
                (@CD_EMP     INT ,       --Codigo da Empresa
                 @CD_FIL     VARCHAR(2500),    --Codigo da Filial
                 @CD_PED_SOL VARCHAR(2500),     --Codigo do Pedido de Solicitacao
                 @STS_PED    VARCHAR(4000),     --Status Pedido
				 @CD_FORN    INT,
				 @CONDICAO   INT,
				 @PHLINK     INT,
				 @COMPRA_OL  INT
)

RETURNS  @BUSCA_QT_SOL_PED_CP TABLE  (
									CD_EMP						INT,
									CD_FILIAL					INT,
									CD_FORN						INT,
									CD_PED						INT,
									CD_PED_SOL					INT,
									CD_PROD						INT,
									DS_PROD						VARCHAR(160),
									DS_UN						VARCHAR(5),
									QT_IT_SOL					MONEY,
									QT_IT_AT					MONEY,
									VLR_TOT_PROD				MONEY,
									QT_SLD						MONEY,
									QT_IT_CP_UND				MONEY,
									CD_PROD_FORN				VARCHAR(30),
									CD_FABRIC					INT,
									PERC_DESC					MONEY,
									CD_CTR_ENV					MONEY)
AS
BEGIN
DECLARE @RS_PROD_SLD TABLE (
											CD_EMP 				INT,
											CD_FIL_ENTR		INT, 
											CD_PED_SOL 		INT, 
											CD_PROD 			INT, 
											SLD_PROD 			MONEY)

INSERT INTO @RS_PROD_SLD
	SELECT 
		DISTINCT 
			CD_EMP,
			CD_FIL_ENTR, 
			CD_PED_SOL, 	
			CD_PROD, 
			ISNULL(SUM(QT_IT_CP),0)
	FROM         
		V_EST_PED_ELTR_FORN_EST_PED_CP
	WHERE     
		CD_EMP = @CD_EMP
		AND CD_FIL_ENTR IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_FIL)) 
		AND CD_PED_SOL IN(SELECT ID FROM UFD_PRM_IN_STRING(@CD_PED_SOL))
	GROUP BY 
			CD_EMP,
			CD_FIL_ENTR, 
			CD_PED_SOL, 	
			CD_PROD

INSERT INTO @BUSCA_QT_SOL_PED_CP
	SELECT DISTINCT 
		V_EST_PED_ELTR_FORN.CD_EMP, 
		V_EST_PED_ELTR_FORN.CD_FIL_ENTR AS CD_FILIAL, 
		ISNULL(V_EST_PED_ELTR_FORN.CD_FORN, 0) AS CD_FORN, 
		0, 
		V_EST_PED_ELTR_FORN.CD_PED_SOL, 
		V_EST_PED_ELTR_FORN.CD_PROD, 
		EST_PROD.DS_PROD, 
		EST_PROD_UN_MED.DS_UN, 
		V_EST_PED_ELTR_FORN.QT_IT_CP AS QT_IT_SOL, 
		0, 		
        V_EST_PED_ELTR_FORN.QT_IT_CP * V_EST_PED_ELTR_FORN.VLR_PROD AS VLR_TOT_PROD,
		V_EST_PED_ELTR_FORN.QT_IT_CP,
		V_EST_PED_ELTR_FORN.QT_SLD_UND,
		f.CD_PROD_FORN,
		EST_PROD.CD_FABRIC,
		0,
		ISNULL((SELECT MAX(fenv.CD_CTR_ENV) 
		  	    FROM EST_PED_ELTR_FORN_CTR_ENV fenv
			    WHERE  fenv.CD_EMP			= V_EST_PED_ELTR_FORN.CD_EMP 
						AND fenv.CD_PED_SOL = V_EST_PED_ELTR_FORN.CD_PED_SOL
						AND fenv.CD_FORN    = CASE when @CD_FORN= 0 THEN V_EST_PED_ELTR_FORN.CD_FORN ELSE @CD_FORN END ),0)
	FROM  
		V_EST_PED_ELTR_FORN INNER JOIN EST_PROD ON 
		V_EST_PED_ELTR_FORN.CD_EMP = EST_PROD.CD_EMP AND 
		V_EST_PED_ELTR_FORN.CD_PROD = EST_PROD.CD_PROD
		INNER JOIN EST_PROD_UN_MED ON
		EST_PROD.CD_EMP = EST_PROD_UN_MED.CD_EMP AND 
		EST_PROD.CD_UN_CP = EST_PROD_UN_MED.CD_CTR_UN
		INNER JOIN EST_PROD_FORN f ON
		V_EST_PED_ELTR_FORN.CD_EMP= f.CD_EMP AND
		V_EST_PED_ELTR_FORN.CD_PROD = f.CD_PROD AND
		CASE when @CD_FORN= 0 THEN V_EST_PED_ELTR_FORN.CD_FORN ELSE @CD_FORN END  = f.CD_FORN
	WHERE
		V_EST_PED_ELTR_FORN.CD_EMP = @CD_EMP 
		AND V_EST_PED_ELTR_FORN.CD_FIL_ENTR IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_FIL)) 
		AND V_EST_PED_ELTR_FORN.CD_PED_SOL IN(SELECT ID FROM UFD_PRM_IN_STRING(@CD_PED_SOL))
		AND V_EST_PED_ELTR_FORN.STS_PED IN (SELECT ID FROM UFD_PRM_IN_STRING(@STS_PED))
		AND V_EST_PED_ELTR_FORN.STS_PED <> 3		
		AND V_EST_PED_ELTR_FORN.FLAG_FECHAR = 0
		AND V_EST_PED_ELTR_FORN.CD_FORN = CASE when @CD_FORN= 0 THEN V_EST_PED_ELTR_FORN.CD_FORN ELSE @CD_FORN END
		AND f.COMPRA_INATIVA=0
		AND f.COMPRA_OL = CASE WHEN @COMPRA_OL = 2 THEN f.COMPRA_OL ELSE @COMPRA_OL END
		AND EST_PROD.FLAG_COMPRA_PHARMALINK = CASE WHEN @PHLINK = 1 THEN 
													@PHLINK 
											  WHEN @PHLINK = 0 THEN 
													0 
											  ELSE 
													FLAG_COMPRA_PHARMALINK 
											  END
											  

--Fim

--Somente produto de melhor codi��o no fornecedor
--IF @CONDICAO > 0 
--BEGIN
--	DELETE FROM 
--		p
--	FROM 
--		@BUSCA_QT_SOL_PED_CP p
--	WHERE
--		NOT EXISTS(			
--			SELECT     
--				EST_PROD_FABRIC_PG_FORN.CD_ORDEM
--			FROM         
--				EST_PROD_FABRIC_PG_FORN 
--			WHERE     
--				EST_PROD_FABRIC_PG_FORN.CD_EMP = p.CD_EMP AND 
--				EST_PROD_FABRIC_PG_FORN.CD_FABRIC = p.CD_FABRIC AND
--				EST_PROD_FABRIC_PG_FORN.CD_EMP = @CD_EMP 
--				AND EST_PROD_FABRIC_PG_FORN.CD_FORN = @CD_FORN 
--				AND EST_PROD_FABRIC_PG_FORN.CD_ORDEM = @CONDICAO)
--UPDATE
--	p
--SET
--	p.PERC_DESC = f.PERC_DESC
--FROM
--	@BUSCA_QT_SOL_PED_CP p INNER JOIN EST_PROD_FABRIC_PG_FORN f ON
--	f.CD_EMP = p.CD_EMP AND 
--	f.CD_FABRIC = p.CD_FABRIC AND
--	f.CD_EMP = @CD_EMP 
--	AND f.CD_FORN = @CD_FORN 
--	AND f.CD_ORDEM = @CONDICAO	
--END
--Fim 


--Por percentual de desconto no produto
IF @CONDICAO = 0
begin 
	UPDATE
		p
	SET
		p.PERC_DESC = f.PERC_DESC
	FROM
		@BUSCA_QT_SOL_PED_CP p INNER JOIN EST_PROD_FORN_PERC_DESC f ON
		f.CD_EMP = p.CD_EMP AND 
		f.CD_PROD = p.CD_PROD AND
		f.CD_EMP = @CD_EMP 
		AND f.CD_FORN = CASE when @CD_FORN= 0 THEN F.CD_FORN ELSE @CD_FORN END 
	--Fim 

	--Por valor do produto
	UPDATE
		p
	SET
		p.VLR_TOT_PROD = p.QT_IT_SOL * f.VLR_PROD,
		p.PERC_DESC = f.PERC_DESC
	FROM
		@BUSCA_QT_SOL_PED_CP p INNER JOIN EST_PROD_FORN_PERC_DESC f ON
		f.CD_EMP = p.CD_EMP AND 
		f.CD_PROD = p.CD_PROD AND
		f.CD_EMP = @CD_EMP 
		AND f.CD_FORN = CASE when @CD_FORN= 0 THEN F.CD_FORN ELSE @CD_FORN END 
		AND F.VLR_PROD > 0
	--Fim 
end
--Somente produto de melhor codi��o no fornecedor
--Por importa��o de arquivos
IF @CONDICAO > 0 
	BEGIN
		DELETE FROM 
			p
		FROM 
			@BUSCA_QT_SOL_PED_CP p
		WHERE
			NOT EXISTS(			
				SELECT     
					V_EST_PROD_COND_CP_PG_FORN_VIGENTE.CD_ORDEM
				FROM         
					V_EST_PROD_COND_CP_PG_FORN_VIGENTE 
				WHERE     
					V_EST_PROD_COND_CP_PG_FORN_VIGENTE.CD_EMP = p.CD_EMP AND 
					V_EST_PROD_COND_CP_PG_FORN_VIGENTE.CD_PROD = p.CD_PROD AND 
					V_EST_PROD_COND_CP_PG_FORN_VIGENTE.CD_EMP = @CD_EMP 
					AND V_EST_PROD_COND_CP_PG_FORN_VIGENTE.CD_FORN = CASE when @CD_FORN= 0 THEN V_EST_PROD_COND_CP_PG_FORN_VIGENTE.CD_FORN ELSE @CD_FORN END
					AND V_EST_PROD_COND_CP_PG_FORN_VIGENTE.CD_ORDEM = @CONDICAO)
		UPDATE
			p
		SET
			p.VLR_TOT_PROD = p.QT_IT_SOL * f.VLR_CUSTO,
			p.PERC_DESC = f.PERC_DESC
		FROM
			@BUSCA_QT_SOL_PED_CP p INNER JOIN V_EST_PROD_COND_CP_PG_FORN_VIGENTE f ON
			f.CD_EMP = p.CD_EMP AND 
			f.CD_PROD = p.CD_PROD AND 	
			f.CD_EMP = @CD_EMP 
			AND f.CD_FORN = CASE when @CD_FORN= 0 THEN F.CD_FORN ELSE @CD_FORN END 
			AND f.CD_ORDEM = @CONDICAO	
	END
--Fim 


UPDATE
	@BUSCA_QT_SOL_PED_CP
SET 
	QT_IT_AT = RS_PROD_SLD.SLD_PROD,
	QT_SLD = BUSCA_QT_SOL_PED_CP.QT_IT_SOL - RS_PROD_SLD.SLD_PROD
FROM 
	@RS_PROD_SLD RS_PROD_SLD INNER JOIN  @BUSCA_QT_SOL_PED_CP BUSCA_QT_SOL_PED_CP ON
	RS_PROD_SLD.CD_EMP   = BUSCA_QT_SOL_PED_CP.CD_EMP		AND
	RS_PROD_SLD.CD_PED_SOL = BUSCA_QT_SOL_PED_CP.CD_PED_SOL	AND
	RS_PROD_SLD.CD_FIL_ENTR =  BUSCA_QT_SOL_PED_CP.CD_FILIAL AND
	RS_PROD_SLD.CD_PROD = BUSCA_QT_SOL_PED_CP.CD_PROD

UPDATE
	@BUSCA_QT_SOL_PED_CP
set 
	CD_PED = CD_PED_CP
FROM 
	V_EST_PED_ELTR_FORN_EST_PED_CP,
	@BUSCA_QT_SOL_PED_CP BUSCA_QT_SOL_PED_CP
WHERE
	V_EST_PED_ELTR_FORN_EST_PED_CP.CD_EMP   = BUSCA_QT_SOL_PED_CP.CD_EMP			AND
	V_EST_PED_ELTR_FORN_EST_PED_CP.CD_PED_SOL = BUSCA_QT_SOL_PED_CP.CD_PED_SOL	AND
	V_EST_PED_ELTR_FORN_EST_PED_CP.CD_FIL_ENTR =  BUSCA_QT_SOL_PED_CP.CD_FILIAL AND
	V_EST_PED_ELTR_FORN_EST_PED_CP.CD_FORN = BUSCA_QT_SOL_PED_CP.CD_FORN
RETURN		
END


GO


